////////////////////////////////////////////////////
// File:	"CCreditsState.cpp"
//
// Author:	Jason Stegner (JS)
//
// Purpose: Creates and displays the credits screen for the game.
////////////////////////////////////////////////////

#include "CCreditsState.h"
#include "CSGD_DirectInput.h"
#include "CGame.h"
#include "CMainMenuState.h"
#include "CSGD_TextureManager.h"
#include "CSGD_FModManager.h"


///////////////////////////////////////////////
//	Function:	"GetInstance"
//	Purpose:	Returns the instance of the Credits State
///////////////////////////////////////////////
CCreditsState* CCreditsState::GetInstance()
{
	static CCreditsState instance;
	return &instance;
}

///////////////////////////////////////////////
//	Function:	"CCreditsState"
//	Purpose:	Constructor
///////////////////////////////////////////////
CCreditsState::CCreditsState()
{
	// Initialize the background image id to -1
	m_nStaffID = -1;

	

	tTextScroll text;
	//m_vCredits
	text.szText = "Alyssa Dettling - Programmer";
	text.defaultX = 810;
	text.defaultY = 60;
	text.currentX = 810;
	text.currentY = 60;

	m_vCredits1.push_back(text);

	text.szText = "Dakota Humphries - Programmer";
	text.defaultX = 890;
	text.defaultY = 170;
	text.currentX = 890;
	text.currentY = 170;

	m_vCredits2.push_back(text);

	text.szText = "Christopher Hays - Programmer";
	text.defaultX = 970;
	text.defaultY = 280;
	text.currentX = 970;
	text.currentY = 280;

	m_vCredits3.push_back(text);

	text.szText = "Sean Murray - Programmer";
	text.defaultX = 1050;
	text.defaultY = 390;
	text.currentX = 1050;
	text.currentY = 390;

	m_vCredits4.push_back(text);

	text.szText = "Glenn DiGirolamo - Lead Artist";
	text.defaultX = 1320;
	text.defaultY = 60;
	text.currentX = 1320;
	text.currentY = 60;

	m_vCredits1.push_back(text);

	text.szText = "Jay Baird - Assistant Programmer";
	text.defaultX = 1400;
	text.defaultY = 170;
	text.currentX = 1400;
	text.currentY = 170;

	m_vCredits2.push_back(text);

	text.szText = "Jason Ware - Assistant Programmer";
	text.defaultX = 1470;
	text.defaultY = 280;
	text.currentX = 1470;
	text.currentY = 280;

	m_vCredits3.push_back(text);

	text.szText = "Ari Patrick - Assistant Programmer";
	text.defaultX = 1540;
	text.defaultY = 390;
	text.currentX = 1540;
	text.currentY = 390;

	m_vCredits4.push_back(text);

	text.szText = "Steve VanZandt - Supervisor";
	text.defaultX = 1850;
	text.defaultY = 60;
	text.currentX = 1850;
	text.currentY = 60;

	m_vCredits1.push_back(text);

	text.szText = "Ludovico Einaudi - Music";
	text.defaultX = 1930;
	text.defaultY = 170;
	text.currentX = 1930;
	text.currentY = 170;

	m_vCredits2.push_back(text);

	text.szText = "DJ Tiesto - Music";
	text.defaultX = 2000;
	text.defaultY = 280;
	text.currentX = 2000;
	text.currentY = 280;

	m_vCredits3.push_back(text);

	m_pBM = CBitmapFontManager::GetInstance();
	m_pFont = m_pBM->CreateTemplateInstance(m_pBM->LoadTemplate("Resources/menuFont.xml"));
	m_pFont.LoadKerning("Resources/YesterdayFONT.dat");
	m_pFont.SetScaleX(0.9f);
	m_pFont.SetScaleY(0.9f);
}

///////////////////////////////////////////////
//	Function:	"~CCreditsState"
//	Purpose:	Destructor
///////////////////////////////////////////////
CCreditsState::~CCreditsState()
{


}

///////////////////////////////////////////////
//	Function:	"Enter"
//	Purpose:	Starts up the Credits State
///////////////////////////////////////////////
void CCreditsState::Enter()
{

	// Set up the background image
	m_nStaffID = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/Staff_Blue.png");
	m_nTeamLogo = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/Equalizer_Logo1.png");
	m_nGlobalGamJamLogo = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/ggj.png");
	m_nIGDSLogo = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/sig_igda.png");
	m_nFullSailLogo = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/FullSailUniversityLogo.png");
	m_fTeamLogoPosX = 2400.0f;
}

///////////////////////////////////////////////
//	Function:	"Input"
//	Purpose:	Takes in and handles input for the Credits State
///////////////////////////////////////////////
bool CCreditsState::Input(float fElapsedTime)
{
	CSGD_DirectInput* pDI = CSGD_DirectInput::GetInstance();
	// Return to the main menu if the user presses Enter or Escape
	if(pDI->GetBufferedKey(DIK_ESCAPE) || pDI->GetBufferedKey(DIK_RETURN))
	{
		CGame::GetInstance()->RemoveAllStates();
		CGame::GetInstance()->AddState(CMainMenuState::GetInstance());
	}



	return true;
}

///////////////////////////////////////////////
//	Function:	"Update"
//	Purpose:	Updates the Credits State
///////////////////////////////////////////////
void CCreditsState::Update(float fElapsedTime)
{
	for(std::list<tTextScroll>::iterator pIter = m_vCredits1.begin(); pIter != m_vCredits1.end(); ++pIter)
		(*pIter).currentX -= 0.1f;
	for(std::list<tTextScroll>::iterator pIter = m_vCredits2.begin(); pIter != m_vCredits2.end(); ++pIter)
		(*pIter).currentX -= 0.1f;
	for(std::list<tTextScroll>::iterator pIter = m_vCredits3.begin(); pIter != m_vCredits3.end(); ++pIter)
		(*pIter).currentX -= 0.1f;
	for(std::list<tTextScroll>::iterator pIter = m_vCredits4.begin(); pIter != m_vCredits4.end(); ++pIter)
		(*pIter).currentX -= 0.1f;
	m_fTeamLogoPosX -= 0.1f;

	if(m_fTeamLogoPosX <= -650.0f)
	{
		for(std::list<tTextScroll>::iterator pIter = m_vCredits1.begin(); pIter != m_vCredits1.end(); ++pIter)
			(*pIter).currentX = (*pIter).defaultX;
		for(std::list<tTextScroll>::iterator pIter = m_vCredits2.begin(); pIter != m_vCredits2.end(); ++pIter)
			(*pIter).currentX = (*pIter).defaultX;
		for(std::list<tTextScroll>::iterator pIter = m_vCredits3.begin(); pIter != m_vCredits3.end(); ++pIter)
			(*pIter).currentX = (*pIter).defaultX;
		for(std::list<tTextScroll>::iterator pIter = m_vCredits4.begin(); pIter != m_vCredits4.end(); ++pIter)
			(*pIter).currentX = (*pIter).defaultX;
		m_fTeamLogoPosX = 2400.0f;
	}
}

///////////////////////////////////////////////
//	Function:	"Render"
//	Purpose:	Draws the Credits State
///////////////////////////////////////////////
void CCreditsState::Render()
{
	static CSGD_Direct3D* pD3D = CSGD_Direct3D::GetInstance();
	pD3D->Clear(35, 82, 36);

	CSGD_TextureManager* pTM = CSGD_TextureManager::GetInstance();
	pTM->DrawTexture(m_nStaffID, 0.0f, 35.0f, 0.5f, 1.0f, 1.0f, NULL, 0.0f, 0.0f, 0.0f);
	pTM->DrawTexture(m_nStaffID, 0.0f, 145.0f, 0.5f, 1.0f, 1.0f, NULL, 0.0f, 0.0f, 0.0f);
	pTM->DrawTexture(m_nStaffID, 0.0f, 255.0f, 0.5f, 1.0f, 1.0f, NULL, 0.0f, 0.0f, 0.0f);
	pTM->DrawTexture(m_nStaffID, 0.0f, 365.0f, 0.5f, 1.0f, 1.0f, NULL, 0.0f, 0.0f, 0.0f);

	for(std::list<tTextScroll>::iterator pIter = m_vCredits1.begin(); pIter != m_vCredits1.end(); ++pIter)
		m_pFont.DrawString((*pIter).szText.c_str(), (int)(*pIter).currentX, (int)(*pIter).currentY, D3DXCOLOR(255, 0, 0, 255));
	for(std::list<tTextScroll>::iterator pIter = m_vCredits2.begin(); pIter != m_vCredits2.end(); ++pIter)
		m_pFont.DrawString((*pIter).szText.c_str(), (int)(*pIter).currentX, (int)(*pIter).currentY, D3DXCOLOR(255, 0, 0, 255));
	for(std::list<tTextScroll>::iterator pIter = m_vCredits3.begin(); pIter != m_vCredits3.end(); ++pIter)
		m_pFont.DrawString((*pIter).szText.c_str(), (int)(*pIter).currentX, (int)(*pIter).currentY, D3DXCOLOR(255, 0, 0, 255));
	for(std::list<tTextScroll>::iterator pIter = m_vCredits4.begin(); pIter != m_vCredits4.end(); ++pIter)
		m_pFont.DrawString((*pIter).szText.c_str(), (int)(*pIter).currentX, (int)(*pIter).currentY, D3DXCOLOR(255, 0, 0, 255));
	pTM->DrawTexture(m_nTeamLogo, m_fTeamLogoPosX, 100.0f, 0.0f, 0.6f, 0.6f, NULL);

	pTM->DrawTexture(m_nFullSailLogo, 10, 460, 0.5f, 0.5f, 0.5f, NULL);
	pTM->DrawTexture(m_nIGDSLogo, 250, 460, 0.5f, 0.60f, 0.60f, NULL);
	pTM->DrawTexture(m_nGlobalGamJamLogo, 600, 460, 0.05f, 0.5f, 0.5f, NULL);
}
	
///////////////////////////////////////////////
//	Function:	"Exit"
//	Purpose:	Shuts down the Credits State
///////////////////////////////////////////////
void CCreditsState::Exit()
{
	//m_Wrapper.Clear();
	//CSGD_TextureManager::GetInstance()->ReleaseTexture(m_nBGImage);
	//m_nBGImage = -1;

	CSGD_TextureManager::GetInstance()->ReleaseTexture(m_nStaffID);
	CSGD_TextureManager::GetInstance()->ReleaseTexture(m_nTeamLogo);
	CSGD_TextureManager::GetInstance()->ReleaseTexture(m_nGlobalGamJamLogo);
	CSGD_TextureManager::GetInstance()->ReleaseTexture(m_nIGDSLogo);
	CSGD_TextureManager::GetInstance()->ReleaseTexture(m_nFullSailLogo);
}
